unit MainFrm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics,
  Controls, Forms, Dialogs, StdCtrls, SURandom, SUPasswords;

type
  TForm1 = class(TForm)
    btnGenerate: TButton;
    mmResult: TMemo;
    cbUseUpperCase: TCheckBox;
    cbUseLowerCase: TCheckBox;
    cbUseDigits: TCheckBox;
    cbUseSymbols: TCheckBox;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure btnGenerateClick(Sender: TObject);
  private
    { Private declarations }
    FRandomGenerator: TSUFastRandomGenerator;
    FPassword: TSUPasswordGenerator;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.btnGenerateClick(Sender: TObject);
begin
  FPassword.UseUpperCase := cbUseUpperCase.Checked;
  FPassword.UseLowerCase := cbUseLowerCase.Checked;
  FPassword.UseDigits := cbUseDigits.Checked;
  FPassword.UseSymbols := cbUseSymbols.Checked;

  mmResult.Lines.Add(FPassword.Generate(8));
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  FRandomGenerator := TSUFastRandomGenerator.Create(nil);
  FPassword := TSUPasswordGenerator.Create(nil);

  FPassword.OwnRandomGenerator := true;
  FPassword.RandomGenerator := FRandomGenerator;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  FPassword.Free;
end;

end.
